/*********************************************************************
Based on the Arduino VGA library by https://simple-circuit.com/
The Arduino VGA library is also based on the VGAX Library at https://github.com/smaffer/vgax
*********************************************************************/
//Modified and optimised by K. Jardine for the MI2955 Composite Video & VGA board, 19th March 2021
//This code is specifically for Composite Video for PCB Version 3.1

#ifndef _CV_PCBV3_V1_0_H
#define _CV_PCBV3_V1_0_H

#if defined(ARDUINO) && ARDUINO >= 100
  #include "Arduino.h"
#else
  #include "WProgram.h"
  #include "pins_arduino.h"
#endif

#define _CYCLES_PER_US			(F_CPU / 1000000) //Defines the processor speed

//PAL definitions
#define PALscrollRows 4 //The number of character rows scrolled when in PAL
#define PALCcorrectionOffset 1 //The number of character rows offset when in PAL to set the reference display position
#define _PAL_TIME_SCANLINE 64 //uS
#define PAL_CYCLES_SCANLINE	 ((_PAL_TIME_SCANLINE * _CYCLES_PER_US) - 1) //Sets the Horizontal Sync period
#define _PAL_TIME_HORZ_SYNC	4.7 //uS
#define PAL_CYCLES_HORZ_SYNC ((_PAL_TIME_HORZ_SYNC * _CYCLES_PER_US) - 1) //Sets the Horizontal Sync pulse duration
#define _PAL_TIME_VERT_SYNC	58.85 //uS
#define PAL_CYCLES_VERT_SYNC ((_PAL_TIME_VERT_SYNC * _CYCLES_PER_US) - 1) //The Horizontal Sync pulse duration (Inverted Line Sync) during the Vertical Sync pulse
#define PAL_LINES 312 //The number of lines in a PAL frame
#define PAL_LINE_CHANGE 7 //The line where the Inverted Line Sync reverts to Non Inverted Line Sync. Inverted Line Sync occurs during the Vertical Sync pulse
#define PAL_VIDEO_HEIGHT 256 //Defines the number of lines forming the image
#define PAL_VIDEO_WIDTH 55 //Note that fine tuning of the image width can be done in the Timer1 Overflow Interrupt Service Routine but it will affect both PAL & NTSC
#define PAL_START_LINE 20 //Start line
#define PAL_END_LINE (PAL_START_LINE + PAL_VIDEO_HEIGHT) //End line
#define _PAL_TIME_OUTPUT_START 14 //uS
#define PAL_CYCLES_OUTPUT_START ((_PAL_TIME_OUTPUT_START * _CYCLES_PER_US) - 1) //Determines the starting position across the line

//NTSC definitions
#define NTSCscrollRows 5 //The number of character rows scrolled when in NTSC
#define NTSCcorrectionOffset 1 //The number of character rows offset when in NTSC to set the reference display position
#define _NTSC_TIME_SCANLINE  63.55 //uS
#define NTSC_CYCLES_SCANLINE  ((_NTSC_TIME_SCANLINE * _CYCLES_PER_US) - 1) //Sets the Horizontal Sync period
#define _NTSC_TIME_HORZ_SYNC  4.7 //uS
#define NTSC_CYCLES_HORZ_SYNC ((_NTSC_TIME_HORZ_SYNC * _CYCLES_PER_US) - 1) //Sets the Horizontal Sync pulse duration
#define _NTSC_TIME_VERT_SYNC  58.85 //uS
#define NTSC_CYCLES_VERT_SYNC ((_NTSC_TIME_VERT_SYNC * _CYCLES_PER_US) - 1) //The Horizontal Sync pulse duration (Inverted Line Sync) during the Vertical Sync pulse
#define NTSC_LINES 262 //The number of lines in a NTSC frame
#define NTSC_LINE_CHANGE 3 //The line where the Inverted Line Sync reverts to Non Inverted Line Sync. Inverted Line Sync occurs during the Vertical Sync pulse
#define NTSC_VIDEO_HEIGHT 216 //Defines the number of lines forming the image
#define NTSC_VIDEO_WIDTH 53 //Note that fine tuning of the image width can be done in the Timer1 Overflow Interrupt Service Routine but it will affect both PAL & NTSC
#define NTSC_START_LINE 23 //Start line
#define NTSC_END_LINE (NTSC_START_LINE + NTSC_VIDEO_HEIGHT) //End line
#define _NTSC_TIME_OUTPUT_START 12 //uS
#define NTSC_CYCLES_OUTPUT_START ((_NTSC_TIME_OUTPUT_START * _CYCLES_PER_US) - 1) //Determines the starting position across the line

class CV {
  public:
  void begin(bool NTSC_PAL);
};

extern const byte VCClk; //Port D7, Vertical Counter Clock Output
extern const byte PE_A2; //Port D11, Vertical Line Counter Scroll bit 2 output
extern const byte PE_A2_PortBpin3; //Port D11, Vertical Line Counter Scroll bit 2 output, PortB Pin 3
extern const byte PE_A1_HCCPortBpin2; //Port D10, Vertical Line Counter Scroll bit 1 output, Horizontal Counter Clear Output, PortB Pin 2
extern const byte PE_A1_HCC; //Port D10, Vertical Line Counter Scroll bit 1 output, Horizontal Counter Clear Output
extern const byte VOE; //Port D6, Video Out Enable
extern const byte FS_LS; //Port D9, Composite Video Frame Sync/Line Sync Output
extern uint16_t line; //Line counter for counting the lines down the screen
extern uint8_t width; //The image width variable for counting image placement across the screen
extern bool bool_scroll; //Scroll if false. No scroll if true. Scrolls 8 lines when NTSC or 3 lines when PAL.
extern int8_t height_offset; //An offset to adjust the screen image height
extern int8_t start_line_offset; //An offset to adjust the image position down the screen
extern int scroll_offset; //An offset to adjust the scroll value
extern const byte PE_A0_PortCpin0; //Port A0, Vertical Line Counter Scroll bit 0 output
extern const byte PE_A3; //Port D12, Vertical Line Counter Scroll bit 3 output
extern const byte PE_A3_PortBpin4; //Port D12, Vertical Line Counter Scroll bit 3 output, PortB Pin 4
extern const byte PE_A4; //Port D13, Vertical Line Counter Scroll bit 4 output
extern const byte PE_A4_PortBpin5; //Port D13, Vertical Line Counter Scroll bit 4 output, PortB Pin 5
extern const byte PE__PortCpin1; // Port A1, Vertical Line Counter Parallel Enable output
extern int scroll_cntr; //To debounce the scroll button

#endif
