/*
 Copyright (c) 2010 Myles Metzer

 Permission is hereby granted, free of charge, to any person
 obtaining a copy of this software and associated documentation
 files (the "Software"), to deal in the Software without
 restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following
 conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 OTHER DEALINGS IN THE SOFTWARE.
*/

//Modified and optimised by K. Jardine for the MI2955 Composite Video & VGA board, 19th March 2021
//This code is specifically for VGA for PCB Version 3.1

#ifndef CV_VGA_PCBV3_ASM_MACROS_V1_0_H
#define CV_VGA_PCBV3_ASM_MACROS_V1_0_H

// delay macros
__asm__ __volatile__ (
	// delay 1 clock cycle.
	".macro delay1\n\t"
		"nop\n"
	".endm\n"
	
	// delay 2 clock cycles
	".macro delay2\n\t"
		"nop\n\t"
		"nop\n"
	".endm\n"
	
	// delay 3 clock cyles
	".macro delay3\n\t"
		"nop\n\t"
		"nop\n\t"
		"nop\n"
	".endm\n"
	
	// delay 4 clock cylces
	".macro delay4\n\t"
		".rept 4\n\t"
		"nop\n\t"
		".endr\n"	
	".endm\n"
	
	// delay 5 clock cylces
	".macro delay5\n\t"
		".rept 5\n\t"
		"nop\n\t"
		".endr\n"	
	".endm\n"
	
	// delay 6 clock cylces
	".macro delay6\n\t"
		".rept 6\n\t"
		"nop\n\t"
		".endr\n"	
	".endm\n"
	
	// delay 7 clock cylces
	".macro delay7\n\t"
		".rept 7\n\t"
		"nop\n\t"
		".endr\n"	
	".endm\n"
	
	// delay 8 clock cylces
	".macro delay8\n\t"
		".rept 8\n\t"
		"nop\n\t"
		".endr\n"	
	".endm\n"
	
	// delay 9 clock cylces
	".macro delay9\n\t"
		".rept 9\n\t"
		"nop\n\t"
		".endr\n"	
	".endm\n"
	
	// delay 10 clock cylces
	".macro delay10\n\t"
		".rept 10\n\t"
		"nop\n\t"
		".endr\n"		
	".endm\n"
); // end of delay macros

// common output macros
__asm__ __volatile__ (
	
	// save port in R16 and clear the Video Output Enable bit D6
	".macro svprtc6 p\n\t"
		"in		r16,\\p\n\t"
		"andi	r16,0xBF\n" //D6 = 0
	".endm\n"
	
	// save port in R16 and clear the Vertical Counter Clock & Video Output Enable bits D7 & D6
	".macro svprtc76 p\n\t"
		"in		r16,\\p\n\t"
		"andi	r16,0x3F\n" //D6 & D7 = 0
	".endm\n"
	
	// save port in R16 and set the Vertical Counter Clock & Video Output Enable bits D7 & D6
	".macro svprts76 p\n\t"
		"in		r16,\\p\n\t"
		"ori	r16,0xC0\n" //D6 & D7 = 1
	".endm\n"

  //Port A0, PE_A0_PortCpin0, Save the Vertical Line Counter Scroll bit A0
  ".macro PE_A0 p\n\t"
      "in   r16,\\p\n\t" //Read in the port
      "andi r16,0xFE\n\t" //Clear bit 0 leaving the other port bits the same
      "andi r17,0x01\n\t"  //Clear all the bits to be written except bit 0
      "or R16,R17\n\t" //Combine the existing and new bits together
      "out  \\p,r16\n\t"  //Save to the port 
  ".endm\n"

  //Ports D10-D13, Save the Vertical Line Counter Scroll bits A1-A4
  ".macro PE_A1_4 p\n\t"
      "in   r16,\\p\n\t" //Read in the port
      "andi r16,0xC3\n\t" //Clear bits 2,3,4&5 leaving the other port bits the same 
      "andi r17,0x1E\n\t" //Clear all the bits to be written except bits 1,2,3&4  
      "lsl r17\n\t" //Shift the bits left one place to align them with the port bits      
      "or R16,R17\n\t" //Combine the existing and new bits together
      "out  \\p,r16\n\t"  //Save to the port 
  ".endm\n"
	
); // end of output macros

#endif
