/*********************************************************************
Based on the Arduino VGA library by https://simple-circuit.com/
The Arduino VGA library is also based on the VGAX Library at https://github.com/smaffer/vgax
*********************************************************************/
//Modified and optimised by K. Jardine for the MI2955 Composite Video & VGA board, 19th March 2021
//This code is specifically for VGA for PCB Version 3.1

#ifndef _VGA_PCBV3_V1_0_H
#define _VGA_PCBV3_V1_0_H

#if defined(ARDUINO) && ARDUINO >= 100
  #include "Arduino.h"
#else
  #include "WProgram.h"
  #include "pins_arduino.h"
#endif

#define IMAGEHEIGHT 512 //The image height
#define IMAGEWIDTH 39 //Note that fine tuning of the image width can be done in the Timer2 COMPB Interrupt Service Routine.
#define STARTLINE 70  //Start line
#define ENDLINE   (STARTLINE + IMAGEHEIGHT)  //End line

//Timing supports VGA 800x600 56Hz. The Vertical Sync frame is 625 lines for a 600 line display
//Note that the values of 2 used below for HSYNCPeriod & HSYNCPulse derive from 1/(Timer2 clock pulse) ie 1/0.5 = 2
#define HSYNCPeriod 56 // 28.44uS x 2 = 56.88 (minus one) = 56 for HSYNC to pin D3 for 28.44uS period (35.15625 kHz)
#define HSYNCPulse 4 // 2uS x 2 = 4 (minus one) = 3 for HSYNC pulse width of 2uS duration. Also controls where the left
// hand side of the image appears on the screen so increasing the value moves the image to the right.
// The image width value would also need to be reduced to keep within the allowed overall width.
#define VSYNCLineStart 623 //The Vertical Sync pulse duration = 2 lines ie 625-623
#define VSYNCLineStop 625

class VGA {
  public:
  void begin();
};

extern bool CV_VGA_Mode; //Composite Video mode = true (default), VGA mode = false
extern const byte UserJ8pin6; //Port D3, VGA Horizontal Sync Output
extern const byte VCClk; //Port D7, Vertical Counter Clock Output
extern const byte UserJ8pin1; //Port D5, VGA Vertical Sync Output
extern const byte PE_A2; //Port D11, Vertical Line Counter Scroll bit 2 output
extern const byte PE_A2_PortBpin3; //Port D11, Vertical Line Counter Scroll bit 2 output, PortB Pin 3
extern const byte PE_A1_HCC; //Port D10, Vertical Line Counter Scroll bit 1 output, Horizontal Counter Clear Output
extern const byte PE_A1_HCCPortBpin2; //Port D10, Vertical Line Counter Scroll bit 1 output, Horizontal Counter Clear Output, PortB Pin 2
extern const byte VOE; //Port D6, Video Out Enable
extern const byte FS_LS; //Port D9, Composite Video Frame Sync/Line Sync Output
extern uint16_t line; //Line counter for counting the lines down the screen
extern uint8_t width; //The image width variable for counting image placement across the screen
extern const byte PE_A0_PortCpin0; //Port A0, Vertical Line Counter Scroll bit 0 output
extern const byte PE_A3; //Port D12, Vertical Line Counter Scroll bit 3 output
extern const byte PE_A3_PortBpin4; //Port D12, Vertical Line Counter Scroll bit 3 output, PortB Pin 4
extern const byte PE_A4; //Port D13, Vertical Line Counter Scroll bit 4 output
extern const byte PE_A4_PortBpin5; //Port D13, Vertical Line Counter Scroll bit 4 output, PortB Pin 5
extern const byte PE__PortCpin1; // Port A1, Vertical Line Counter Parallel Enable output

#endif
